IF EXISTS(SELECT * FROM sys.objects
			WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_CPL_DEMANDA_PROC_MEDIAP]')
		  AND type IN(N'P', N'PC'))
	DROP PROCEDURE [dbo].[P_EST_PROD_CPL_DEMANDA_PROC_MEDIAP];
GO
GO
CREATE PROCEDURE P_EST_PROD_CPL_DEMANDA_PROC_MEDIAP
AS
BEGIN
	SET CONTEXT_INFO 0x66666;
	PRINT 'Inicio do recalculo MediaP';
    SET NOCOUNT ON;
    DECLARE @CD_CTR_DEMANDA_PROC INT; 
    DECLARE @CD_EMP INT 
	DECLARE @CONTADOR INT
	SET @CONTADOR=0


	CREATE TABLE #RsDemandaProc (CD_CTR_DEMANDA_PROC INT, CD_USU INT, STS_PROC INT)
	CREATE TABLE #RsDemandaProcCplPendente (CD_CTR_DEMANDA_PROC INT)
	CREATE TABLE #RsProcMediaPProcessamento (CD_CTR_PROC_CPL INT)
	
	
/*************************************************************************************************************************************/	
	INSERT INTO #RsDemandaProc
	select
		EST_PROD_CPL_DEMANDA_PROC.CD_CTR,
		EST_PROD_CPL_DEMANDA_PROC.CD_USU,
		1 AS STS_PROC
	from
		EST_PROD_CPL_DEMANDA_PROC 
	WHERE
		EST_PROD_CPL_DEMANDA_PROC.DT_PROC <=GETDATE()
		AND EST_PROD_CPL_DEMANDA_PROC.STS_PROC IN (0,2)
		AND EST_PROD_CPL_DEMANDA_PROC.TP_DEMANDA=1

/*************************************************************************************************************************************/
    DECLARE ProcDemandaPALL CURSOR FAST_FORWARD FOR 
	SELECT
		DISTINCT EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC,
		EST_PROD_CPL_DEMANDA_PROC_CPL.CD_EMP
	from
		#RsDemandaProc p INNER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL ON
		p.CD_CTR_DEMANDA_PROC = EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC
	
		OPEN ProcDemandaPALL;
        FETCH NEXT FROM ProcDemandaPALL INTO @CD_CTR_DEMANDA_PROC,@CD_EMP;
        WHILE @@FETCH_STATUS = 0
            BEGIN
             PRINT 'Demanda '+ CONVERT( VARCHAR(10), @CD_CTR_DEMANDA_PROC) + ' ' + ' contador '+ CONVERT( VARCHAR(10), @CONTADOR) + ' ' + convert(varchar,getdate(),108);

					--Marcando a pendencia ainda pendente para aplicar no cadastro de produtos complemento
					--EST_PROD_CPL
					
					INSERT INTO #RsProcMediaPProcessamento(CD_CTR_PROC_CPL)
					SELECT
						   EST_PROD_CPL_DEMANDA_PROC_CPL_PENDENTE_APLICAR_MEDIAF.CD_CTR_PROC_CPL
					FROM
						EST_PROD_CPL_DEMANDA_PROC_CPL
						LEFT OUTER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL_LIB ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = EST_PROD_CPL_DEMANDA_PROC_CPL_LIB.CD_CTR_PROC_CPL
						INNER JOIN #RsDemandaProc p ON 
							EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC = p.CD_CTR_DEMANDA_PROC
						INNER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL_PENDENTE_APLICAR_MEDIAF ON 
									EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = EST_PROD_CPL_DEMANDA_PROC_CPL_PENDENTE_APLICAR_MEDIAF.CD_CTR_PROC_CPL
					WHERE  EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC = @CD_CTR_DEMANDA_PROC
						   AND EST_PROD_CPL_DEMANDA_PROC_CPL.CD_EMP = @CD_EMP
						   AND EST_PROD_CPL_DEMANDA_PROC_CPL_LIB.CD_CTR_PROC_CPL IS NULL;			
					 
					 

					INSERT INTO   EST_PROD_CPL_DEMANDA_PROC_CPL_LIB( CD_CTR_PROC_CPL
																	 , CD_USU
																	 , DT_CAD
																	 , NM_PARAMETRO_ORIGEM
																	 , PERC_VARIACAO
																	 , CD_CTR_DEMANDA_PARAMETRO)
					SELECT
						   EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR
						 , p.CD_USU
						 , GETDATE()
						 , EST_PROD_CPL_DEMANDA_PROC_CPL.DS_PERC_VARIACAO
						 , EST_PROD_CPL_DEMANDA_PROC_CPL.PERC_VARIACAO
						 , CASE
							   WHEN EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PARAMETRO = 0 THEN NULL
							   ELSE EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PARAMETRO
						   END
					FROM
						EST_PROD_CPL_DEMANDA_PROC_CPL
						LEFT OUTER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL_LIB ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = EST_PROD_CPL_DEMANDA_PROC_CPL_LIB.CD_CTR_PROC_CPL
						INNER JOIN #RsDemandaProc p ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC = p.CD_CTR_DEMANDA_PROC
						LEFT OUTER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL_BLOQUEIO ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = EST_PROD_CPL_DEMANDA_PROC_CPL_BLOQUEIO.CD_CTR_PROC_CPL
						INNER JOIN #RsProcMediaPProcessamento pendMediaP ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = pendMediaP.CD_CTR_PROC_CPL
					WHERE  EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC = @CD_CTR_DEMANDA_PROC
						   AND EST_PROD_CPL_DEMANDA_PROC_CPL.CD_EMP = @CD_EMP 
						   AND EST_PROD_CPL_DEMANDA_PROC_CPL_LIB.CD_CTR_PROC_CPL IS NULL
						   AND EST_PROD_CPL_DEMANDA_PROC_CPL_BLOQUEIO.CD_CTR_PROC_CPL IS NULL;
				    
					--Zerando MediaF 
					UPDATE EST_PROD_CPL_MEDIAF
					SET
						  QTDE_MEDIAF = 0
						, CD_CTR_PROC_CPL_LIB = NULL
						, CD_USU = P.CD_USU
						, DT_ULT_ALT = GETDATE()
						, QT_VD_ATUAL = 0
						, QT_VD_MES1 = 0
						, QT_VD_MES2 = 0
						, QT_VD_MES3 = 0
						, LIMITP = 0
						, LIMITV = 0
						, SAZ = 0
						, DT_NASC = NULL
						, CD_SIGLA = 4
					FROM   EST_PROD_CPL_MEDIAF
						   INNER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL ON EST_PROD_CPL_MEDIAF.CD_EMP = EST_PROD_CPL_DEMANDA_PROC_CPL.CD_EMP
																	   AND EST_PROD_CPL_MEDIAF.CD_FILIAL = EST_PROD_CPL_DEMANDA_PROC_CPL.CD_FILIAL
																	   AND EST_PROD_CPL_MEDIAF.CD_PROD = EST_PROD_CPL_DEMANDA_PROC_CPL.CD_PROD
						   INNER JOIN #RsProcMediaPProcessamento pendMediaP ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = pendMediaP.CD_CTR_PROC_CPL
						   INNER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL_LIB ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = EST_PROD_CPL_DEMANDA_PROC_CPL_LIB.CD_CTR_PROC_CPL
						   INNER JOIN #RsDemandaProc p ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC = p.CD_CTR_DEMANDA_PROC
					WHERE
						  EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC = @CD_CTR_DEMANDA_PROC
						  AND EST_PROD_CPL_DEMANDA_PROC_CPL.CD_EMP = @CD_EMP; 

					--Matando produto para novo nascimento		 
					DELETE EST_PROD_CPL_NASC
					FROM EST_PROD_CPL_NASC
						 INNER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL ON EST_PROD_CPL_NASC.CD_EMP = EST_PROD_CPL_DEMANDA_PROC_CPL.CD_EMP
																	 AND EST_PROD_CPL_NASC.CD_FILIAL = EST_PROD_CPL_DEMANDA_PROC_CPL.CD_FILIAL
																	 AND EST_PROD_CPL_NASC.CD_PROD = EST_PROD_CPL_DEMANDA_PROC_CPL.CD_PROD
						 INNER JOIN #RsProcMediaPProcessamento pendMediaP ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = pendMediaP.CD_CTR_PROC_CPL
						 INNER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL_LIB ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = EST_PROD_CPL_DEMANDA_PROC_CPL_LIB.CD_CTR_PROC_CPL
						 INNER JOIN #RsDemandaProc p ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC = p.CD_CTR_DEMANDA_PROC
					WHERE
						  EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC = @CD_CTR_DEMANDA_PROC
						  AND EST_PROD_CPL_DEMANDA_PROC_CPL.CD_EMP = @CD_EMP ;

					--Criando mediaP 
					UPDATE EST_PROD_CPL_MEDIAP
					 SET
						  QTDE_MEDIAP = EST_PROD_CPL_DEMANDA_PROC_CPL.QTDE_DEMANDA
						, CD_CTR_PROC_CPL_LIB = EST_PROD_CPL_DEMANDA_PROC_CPL_LIB.CD_CTR
						, CD_USU = P.CD_USU
						, DT_CAD = GETDATE()
						, FALTA_CRONICA = 0
					FROM   EST_PROD_CPL_MEDIAP
						   INNER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL ON EST_PROD_CPL_MEDIAP.CD_EMP = EST_PROD_CPL_DEMANDA_PROC_CPL.CD_EMP
																	   AND EST_PROD_CPL_MEDIAP.CD_FILIAL = EST_PROD_CPL_DEMANDA_PROC_CPL.CD_FILIAL
																	   AND EST_PROD_CPL_MEDIAP.CD_PROD = EST_PROD_CPL_DEMANDA_PROC_CPL.CD_PROD
						   INNER JOIN #RsProcMediaPProcessamento pendMediaP ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = pendMediaP.CD_CTR_PROC_CPL
						   INNER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL_LIB ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = EST_PROD_CPL_DEMANDA_PROC_CPL_LIB.CD_CTR_PROC_CPL
						   INNER JOIN #RsDemandaProc p ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC = p.CD_CTR_DEMANDA_PROC
					WHERE
						  EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC = @CD_CTR_DEMANDA_PROC
						  AND EST_PROD_CPL_DEMANDA_PROC_CPL.CD_EMP = @CD_EMP ;
					-- Desativado pois Existe job para isso-
					-- P_EST_PROD_CPL_REPLIC_EMAX_ESEG

					--Alterando produto complemento	 
					--UPDATE C
					--	SET
					--		C.CD_SIGLA = EST_PROD_CPL_DEMANDA_PROC_CPL.CD_SIGLA
					--	, C.MEDIAF = ISNULL(S.QTDE_MEDIAP, 0)
					--	, C.QT_VD_MES1 = 0
					--	, C.QT_VD_MES2 = 0
					--	, C.QT_VD_MES3 = 0
					--	, C.DT_ATUALIZA_PARAM = GETDATE()
					--FROM   EST_PROD_CPL C
					--		INNER JOIN EST_PROD_CPL_MEDIAP S ON C.CD_EMP = S.CD_EMP
					--											AND C.CD_FILIAL = S.CD_FILIAL
					--											AND C.CD_PROD = S.CD_PROD
					--		INNER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL ON C.CD_EMP = EST_PROD_CPL_DEMANDA_PROC_CPL.CD_EMP
					--													AND C.CD_FILIAL = EST_PROD_CPL_DEMANDA_PROC_CPL.CD_FILIAL
					--													AND C.CD_PROD = EST_PROD_CPL_DEMANDA_PROC_CPL.CD_PROD
					--		INNER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL_LIB ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = EST_PROD_CPL_DEMANDA_PROC_CPL_LIB.CD_CTR_PROC_CPL
					--		INNER JOIN #RsProcMediaPProcessamento pendMediaP ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = pendMediaP.CD_CTR_PROC_CPL
					--WHERE
					--		EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC = @CD_CTR_DEMANDA_PROC
					--		AND EST_PROD_CPL_DEMANDA_PROC_CPL.CD_EMP = @CD_EMP ;



				    TRUNCATE TABLE #RsProcMediaPProcessamento; 
					SET @CONTADOR=@CONTADOR+1
				FETCH NEXT FROM ProcDemandaPALL INTO @CD_CTR_DEMANDA_PROC,@CD_EMP ;
            END;
        PRINT 'Concluido.';
        CLOSE ProcDemandaPALL;
        DEALLOCATE ProcDemandaPALL;
		 
	--Verificando se ainda existe pendencia de aplicacao de mediaF
	INSERT INTO #RsDemandaProcCplPendente
	SELECT DISTINCT
			EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC
	FROM
		#RsDemandaProc p
		INNER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL ON p.CD_CTR_DEMANDA_PROC = EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC
		INNER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL_PENDENTE_APLICAR_MEDIAF ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = EST_PROD_CPL_DEMANDA_PROC_CPL_PENDENTE_APLICAR_MEDIAF.CD_CTR_PROC_CPL;

	UPDATE #RsDemandaProc
		SET
			STS_PROC = 2
	FROM   #RsDemandaProc p
			INNER JOIN #RsDemandaProcCplPendente pend ON p.CD_CTR_DEMANDA_PROC = pend.CD_CTR_DEMANDA_PROC;

	--Indicando que o grupo de processamento ja 
	--analisou a variacao de media nova com a media anterior
	--1 - Nao existe pendencia
	--2 - Existe pendencia para analisar 
	update
		EST_PROD_CPL_DEMANDA_PROC
	set 
		EST_PROD_CPL_DEMANDA_PROC.STS_PROC=p.STS_PROC
	from
		#RsDemandaProc P inner join  EST_PROD_CPL_DEMANDA_PROC ON
		p.CD_CTR_DEMANDA_PROC = EST_PROD_CPL_DEMANDA_PROC.CD_CTR

END